--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A TableVariable takes a lua table and stores the variable in the `id` field in that table.
--- 
--- The TableVariable can be used to save multiple changes to a config file only when the menu is closed. Load the config file with `mwse.loadConfig()`, pass it to any TableVariables in your MCM, and then save it using the `template:saveOnClose()` function.
--- @class mwseMCMTableVariable : mwseMCMVariable
--- @field defaultSetting unknown If `id` does not exist in the table, it will be initialised to this value.
--- @field id string|number Key in the config file used to store the variable.
--- @field table table The table to save the data to.
mwseMCMTableVariable = {}

--- Creates a new variable of this type.
--- @param variable mwseMCMTableVariable.new.variable This table accepts the following values:
--- 
--- `id`: string|number — Key in the config file used to store the variable.
--- 
--- `table`: table — The table to save the data to.
--- 
--- `defaultSetting?`: unknown — *Optional*. If `id` does not exist in the table, it will be initialised to this value.
--- 
--- `inGameOnly?`: boolean — *Default*: `false`. If true, the setting containing this variable will be disabled if the game is on main menu.
--- 
--- `restartRequired?`: boolean — *Default*: `false`. If true, updating the setting containing this variable will notify the player to restart the game.
--- 
--- `restartRequiredMessage?`: string — *Optional*.  The default text is a localized version of: "The game must be restarted before this change will come into effect.".
--- 
--- `converter?`: fun(newValue): unknown — *Optional*. This function is called when the value of the variable is changed. The function can modify the new value before it is saved.
--- @return mwseMCMTableVariable variable No description yet available.
function mwseMCMTableVariable:new(variable) end

---Table parameter definitions for `mwseMCMTableVariable.new`.
--- @class mwseMCMTableVariable.new.variable
--- @field id string|number Key in the config file used to store the variable.
--- @field table table The table to save the data to.
--- @field defaultSetting? unknown *Optional*. If `id` does not exist in the table, it will be initialised to this value.
--- @field inGameOnly? boolean *Default*: `false`. If true, the setting containing this variable will be disabled if the game is on main menu.
--- @field restartRequired? boolean *Default*: `false`. If true, updating the setting containing this variable will notify the player to restart the game.
--- @field restartRequiredMessage? string *Optional*.  The default text is a localized version of: "The game must be restarted before this change will come into effect.".
--- @field converter? fun(newValue): unknown *Optional*. This function is called when the value of the variable is changed. The function can modify the new value before it is saved.

